/*
 * Decompiled with CFR 0.152.
 */
package com.spss.cobalt_laf;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;

public class CobaltGraphicsUtils
extends SynthGraphicsUtils {
    static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nIBM SPSS Products: SPSS Common\n(C) Copyright IBM Corp. 1989, 2011.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    @Override
    public void drawLine(SynthContext synthContext, Object object, Graphics graphics, int n, int n2, int n3, int n4) {
        block4: {
            block3: {
                UIDefaults uIDefaults = UIManager.getDefaults();
                Color color = uIDefaults.getColor("Cobalt.graphicsutils.drawline.color");
                if (color != null) {
                    graphics.setColor(color);
                }
                if (n != n3) break block3;
                n2 += n2 % 2;
                for (int i = n2; i <= n4; i += 2) {
                    graphics.drawLine(n, i, n3, i);
                }
                break block4;
            }
            if (n2 != n4) break block4;
            n += n % 2;
            for (int i = n; i <= n3; i += 2) {
                graphics.drawLine(i, n2, i, n4);
            }
        }
    }

    @Override
    public String layoutText(SynthContext synthContext, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        if (icon != null) {
            n3 = 11;
        }
        return SwingUtilities.layoutCompoundLabel(synthContext.getComponent(), fontMetrics, string, icon, n2, n, n4, n3, rectangle, rectangle2, rectangle3, n5);
    }

    public static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = n; i < n + n3; i += 2) {
            graphics.fillRect(i, n2, 1, 1);
            graphics.fillRect(i, n2 + n4 - 1, 1, 1);
        }
        for (int i = n2; i < n2 + n4; i += 2) {
            graphics.fillRect(n, i, 1, 1);
            graphics.fillRect(n + n3 - 1, i, 1, 1);
        }
    }

    public static Color convertIfColorEqualsBackground(Color color, Color color2) {
        Color color3 = color2;
        if (color2 != null && color2.equals(color)) {
            color3 = color2.equals(Color.black) ? Color.white : color2.darker().darker();
        }
        return color3;
    }

    public static float logicalToPhysicalSize(float f) {
        float f2 = f;
        int n = Toolkit.getDefaultToolkit().getScreenResolution();
        if (n != 72) {
            f2 = f * (float)n / 72.0f;
        }
        return f2;
    }

    public static float physicalToLogicalSize(float f) {
        float f2 = f;
        int n = Toolkit.getDefaultToolkit().getScreenResolution();
        if (n != 72) {
            f2 = f * 72.0f / (float)n;
        }
        return f2;
    }

    public static void paintImage(Image image, Graphics graphics, int n, int n2, int n3, int n4, Insets insets, Insets insets2, boolean bl, boolean bl2) {
        if (image != null) {
            int n5 = image.getWidth(null);
            int n6 = image.getHeight(null);
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            if (insets2 == null) {
                insets2 = new Insets(0, 0, 0, 0);
            }
            graphics.drawImage(image, n, n2, n + insets2.left, n2 + insets2.top, 0, 0, insets.left, insets.top, null);
            CobaltGraphicsUtils.drawChunk(image, graphics, bl, n + insets2.left, n2, n + n3 - insets2.right, n2 + insets2.top, insets.left, 0, n5 - insets.right, insets.top, true);
            graphics.drawImage(image, n + n3 - insets2.right, n2, n + n3, n2 + insets2.top, n5 - insets.right, 0, n5, insets.top, null);
            CobaltGraphicsUtils.drawChunk(image, graphics, bl, n + n3 - insets2.right, n2 + insets2.top, n + n3, n2 + n4 - insets2.bottom, n5 - insets.right, insets.top, n5, n6 - insets.bottom, false);
            graphics.drawImage(image, n + n3 - insets2.right, n2 + n4 - insets2.bottom, n + n3, n2 + n4, n5 - insets.right, n6 - insets.bottom, n5, n6, null);
            CobaltGraphicsUtils.drawChunk(image, graphics, bl, n + insets2.left, n2 + n4 - insets2.bottom, n + n3 - insets2.right, n2 + n4, insets.left, n6 - insets.bottom, n5 - insets.right, n6, true);
            graphics.drawImage(image, n, n2 + n4 - insets2.bottom, n + insets2.left, n2 + n4, 0, n6 - insets.bottom, insets.left, n6, null);
            CobaltGraphicsUtils.drawChunk(image, graphics, bl, n, n2 + insets2.top, n + insets2.left, n2 + n4 - insets2.bottom, 0, insets.top, insets.left, n6 - insets.bottom, false);
            if (bl2) {
                graphics.drawImage(image, n + insets2.left, n2 + insets2.top, n + n3 - insets2.right, n2 + n4 - insets2.bottom, insets.left, insets.top, n5 - insets.right, n6 - insets.bottom, null);
            }
        }
    }

    private static void drawChunk(Image image, Graphics graphics, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        if (bl) {
            graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null);
        } else {
            int n9;
            int n10;
            int n11 = n7 - n5;
            int n12 = n8 - n6;
            if (bl2) {
                n10 = n11;
                n9 = 0;
            } else {
                n10 = 0;
                n9 = n12;
            }
            while (n < n3 && n2 < n4) {
                int n13 = Math.min(n3, n + n11);
                int n14 = Math.min(n4, n2 + n12);
                graphics.drawImage(image, n, n2, n13, n14, n5, n6, n5 + n13 - n, n6 + n14 - n2, null);
                n += n10;
                n2 += n9;
            }
        }
    }
}

