/*
 * Decompiled with CFR 0.152.
 */
package com.spss.cobalt_laf;

import com.spss.cobalt_laf.CobaltGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class CobaltPainter
extends SynthPainter {
    public static final String CompNameToSkipFocusPaint = "CompToSkipFocusPaint";
    private static final Color defaultBdColorEnabled = new Color(55, 67, 151);
    private static final Color defaultBdColorDisabled = new Color(204, 204, 204);
    private static final String submenuName = "Menu.submenu";
    private Color defaultBgColor = UIManager.getColor("Cobalt.default.bg.color");

    static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nIBM SPSS Products: SPSS Common\n(C) Copyright IBM Corp. 1989, 2011.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public Color getDefaultBgColor() {
        if (this.defaultBgColor == null) {
            this.defaultBgColor = UIManager.getColor("Cobalt.default.bg.color");
        }
        return this.defaultBgColor;
    }

    @Override
    public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (synthContext.getComponent().getParent() instanceof JSpinner) {
            UIDefaults uIDefaults = UIManager.getDefaults();
            Color color = uIDefaults.getColor("Cobalt.arrow.bg.color");
            if (color == null) {
                color = Color.WHITE;
            }
            graphics.setColor(color);
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    @Override
    public void paintArrowButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (synthContext.getComponent().getParent() instanceof JSpinner) {
            UIDefaults uIDefaults = UIManager.getDefaults();
            Color color = uIDefaults.getColor("Cobalt.common.border.color.disabled");
            Color color2 = uIDefaults.getColor("Cobalt.arrow.border.color.enabled");
            if ((synthContext.getComponentState() & 8) != 0) {
                color2 = color != null ? color : defaultBdColorDisabled;
            }
            graphics.setColor(color2);
            graphics.drawLine(n, n2, n + n3, n2);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
            graphics.drawLine(n - 1, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
    }

    @Override
    public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        StringBuilder stringBuilder = new StringBuilder("Cobalt.arrow.");
        switch (n5) {
            case 1: {
                stringBuilder.append("up.");
                break;
            }
            case 7: {
                stringBuilder.append("left.");
                break;
            }
            case 5: {
                stringBuilder.append("down.");
                break;
            }
            case 3: {
                stringBuilder.append("right.");
                break;
            }
        }
        if ((synthContext.getComponentState() & 4) != 0) {
            stringBuilder.append("pressed");
        } else if ((synthContext.getComponentState() & 8) != 0) {
            stringBuilder.append("disabled");
        } else if ((synthContext.getComponentState() & 2) != 0) {
            stringBuilder.append("mouseover");
        } else {
            stringBuilder.append("enabled");
        }
        ImageIcon imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, stringBuilder.toString());
        if (imageIcon != null) {
            int n6 = imageIcon.getIconWidth();
            int n7 = imageIcon.getIconHeight();
            int n8 = (n3 - n6) / 2;
            int n9 = (n4 - n7) / 2;
            graphics.drawImage(imageIcon.getImage(), n8, n9, n8 + n6, n9 + n7, 0, 0, n6, n7, null);
        }
    }

    @Override
    public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        boolean bl = false;
        if (jComponent.getParent() instanceof JToolBar && !(bl = jComponent.isFocusable())) {
            return;
        }
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder("Cobalt.button.bg.image.");
        boolean bl3 = "Button.label".equals(jComponent.getName());
        if (bl3) {
            return;
        }
        if ((synthContext.getComponentState() & 4) != 0) {
            stringBuilder.append("pressed");
            bl2 = true;
        } else if ((synthContext.getComponentState() & 2) != 0) {
            stringBuilder.append("mouseover");
        } else if ((synthContext.getComponentState() & 8) != 0) {
            stringBuilder.append("disabled");
        } else {
            stringBuilder.append("normal");
        }
        if ((synthContext.getComponentState() & 0x100) != 0) {
            bl2 = true;
        }
        ImageIcon imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, stringBuilder.toString());
        if (!bl && imageIcon != null) {
            CobaltGraphicsUtils.paintImage(imageIcon.getImage(), graphics, n, n2, n3, n4, new Insets(5, 5, 5, 5), new Insets(5, 5, 5, 5), true, true);
        }
        if (bl2) {
            int n5 = bl ? 1 : 4;
            int n6 = bl ? 1 : 3;
            this.paintFocus(jComponent, graphics, n, n2, n3, n4, n5, n6, true);
        }
    }

    @Override
    public void paintButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintButtonBorder(synthContext, graphics, n, n2, n3, n4, false);
    }

    @Override
    public void paintCheckBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        ImageIcon imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, "CheckBox.icon");
        this.paintCheckRadioBackground(synthContext, graphics, imageIcon, n, n2, n3, n4);
    }

    @Override
    public void paintComboBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        ImageIcon imageIcon;
        boolean bl = false;
        JComboBox jComboBox = (JComboBox)synthContext.getComponent();
        if ((synthContext.getComponentState() & 8) != 0) {
            imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, jComboBox.isEditable() ? "Cobalt.combobox.bg.image.disabled" : "Cobalt.combobox.nonedit.bg.image.disabled");
        } else {
            imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, jComboBox.isEditable() ? "Cobalt.combobox.bg.image.enabled" : "Cobalt.combobox.nonedit.bg.image.enabled");
            if ((synthContext.getComponentState() & 0x100) != 0) {
                bl = true;
            }
        }
        if (imageIcon != null) {
            Image image = imageIcon.getImage();
            CobaltGraphicsUtils.paintImage(image, graphics, n, n2, n3, n4, new Insets(3, 4, 3, 4), new Insets(3, 4, 3, 4), true, true);
        }
        if (jComboBox.getParent() != null && jComboBox.getParent() instanceof JTable) {
            return;
        }
        if (bl && !jComboBox.isEditable()) {
            this.paintFocus(synthContext.getComponent(), graphics, n, n2, n3, n4, 3, 3, true);
        }
    }

    @Override
    public void paintComboBoxBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComboBox jComboBox = (JComboBox)synthContext.getComponent();
        if (jComboBox.isEditable()) {
            this.drawRectBorder(synthContext, graphics, n, n2, n3, n4, false);
        }
    }

    @Override
    public void paintFormattedTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawRectBorder(synthContext, graphics, n, n2, n3, n4, false);
    }

    @Override
    public void paintInternalFrameBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.internalframe.main.color");
        if (color == null) {
            color = Color.GRAY;
        }
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
    }

    @Override
    public void paintInternalFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.internalframe.main.color");
        if (color == null) {
            color = Color.GRAY;
        }
        graphics.setColor(color.darker());
        graphics.drawLine(n, n2 + 1, n, n4 - 2);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n4 - 2);
        graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
        graphics.setColor(color.brighter());
        graphics.drawLine(n + 2, n2 + 3, n + 2, n4 - 4);
        graphics.drawLine(n + n3 - 3, n2 + 3, n + n3 - 3, n4 - 4);
        graphics.drawLine(n + 3, n2 + 2, n + n3 - 4, n2 + 2);
        graphics.drawLine(n + 3, n2 + n4 - 3, n + n3 - 4, n2 + n4 - 3);
    }

    @Override
    public void paintInternalFrameTitlePaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.internalframe.main.color");
        if (color == null) {
            color = Color.GRAY;
        }
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
    }

    @Override
    public void paintInternalFrameTitlePaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.internalframe.main.color");
        if (color == null) {
            color = Color.GRAY;
        }
        graphics.setColor(color.darker());
        graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
    }

    @Override
    public void paintLabelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        Border border = (Border)synthContext.getStyle().get(synthContext, "Table.focusSelectedCellHighlightBorder");
        if (jComponent.getName() != null) {
            if (jComponent.getName().equals("TableHeader.renderer")) {
                Color color = UIManager.getColor("Cobalt.tableHeader.border.color");
                this.paintRaisedBevel(null, synthContext.getComponent(), graphics, n3, n4);
            } else if (jComponent.getName().equals("Table.cellRenderer") && (synthContext.getComponentState() & 0x100) != 0) {
                Color color = UIManager.getColor("Table.focusSelectedCellHighlightBorder");
                CobaltPainter.drawRectBorder(graphics, color, n, n2, n3, n4, false);
            }
        }
    }

    @Override
    public void paintListBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JList jList = (JList)synthContext.getComponent();
        if (!(jList.getParent() instanceof JViewport)) {
            this.drawRectBorder(synthContext, graphics, n, n2, n3, n4, false);
        }
    }

    @Override
    public void paintMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JMenu jMenu = (JMenu)synthContext.getComponent();
        this.setSubmenuNames(jMenu);
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.menu.selected.bg.color.start");
        Color color2 = uIDefaults.getColor("Cobalt.menu.selected.bg.color.end");
        if ((synthContext.getComponentState() & 0x200) != 0) {
            CobaltPainter.gradientFillRect(graphics, n, n2, n3, n4, color, color2, true);
        }
    }

    @Override
    public void paintMenuBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.menuBar.bg.color.start");
        Color color2 = uIDefaults.getColor("Cobalt.menuBar.bg.color.end");
        CobaltPainter.gradientFillRect(graphics, n, n2, n3, n4, color, color2, true);
    }

    @Override
    public void paintMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.doMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void paintCheckBoxMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.doMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.progressbar.bg.color.start");
        Color color2 = uIDefaults.getColor("Cobalt.progressbar.bg.color.end");
        if (color != null && color2 != null) {
            CobaltPainter.gradientFillRect(graphics, n, n2, n3, n4, color, color2, true);
        }
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        ImageIcon imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.progressbar.indication.image");
        if (imageIcon != null && n3 > 0 && n4 > 0) {
            int n5 = imageIcon.getIconWidth();
            int n6 = imageIcon.getIconHeight();
            if (0 == jProgressBar.getOrientation()) {
                graphics2D.setPaint(new Color(0, 0, 0, 130));
                graphics2D.drawLine(n + n5 / 2, (n2 + n4) / 2 - 1, n + n3 - n5 / 2, (n2 + n4) / 2 - 1);
                graphics2D.drawLine(n + n5 / 2, (n2 + n4) / 2 + 1, n + n3 - n5 / 2, (n2 + n4) / 2 + 1);
                graphics2D.setPaint(new Color(0, 0, 0, 255));
                graphics2D.drawLine(n + n5 / 2, (n2 + n4) / 2, n + n3 - n5 / 2, (n2 + n4) / 2);
            } else {
                graphics2D.setPaint(new Color(0, 0, 0, 130));
                graphics2D.drawLine((n + n3) / 2 - 1, n2 + n6 / 2, (n + n3) / 2 - 1, n2 + n4 - n6 / 2);
                graphics2D.drawLine((n + n3) / 2 + 1, n2 + n6 / 2, (n + n3) / 2 + 1, n2 + n4 - n6 / 2);
                graphics2D.setPaint(new Color(0, 0, 0, 255));
                graphics2D.drawLine((n + n3) / 2, n2 + n6 / 2, (n + n3) / 2, n2 + n4 - n6 / 2);
            }
        }
    }

    @Override
    public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawRoundRectBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        ImageIcon imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.progressbar.indication.image");
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        boolean bl = (synthContext.getComponentState() & 8) != 0;
        Color color = UIManager.getDefaults().getColor("Cobalt.progressbar.line.color");
        if (color == null) {
            color = new Color(255, 255, 255, 130);
        }
        if (imageIcon != null && n3 > 0 && n4 > 0) {
            int n6 = imageIcon.getIconWidth();
            int n7 = imageIcon.getIconHeight();
            if (0 == n5) {
                if (!jProgressBar.isIndeterminate() && n3 >= n6) {
                    graphics2D.setPaint(color.brighter());
                    graphics2D.drawLine(n + n6 / 2, (n2 + n4) / 2 - 1, n + n3 - n6 / 2, (n2 + n4) / 2 - 1);
                    graphics2D.setPaint(color.darker());
                    graphics2D.drawLine(n + n6 / 2, (n2 + n4) / 2 + 1, n + n3 - n6 / 2, (n2 + n4) / 2 + 1);
                    graphics2D.setPaint(color);
                    graphics2D.drawLine(n + n6 / 2, (n2 + n4) / 2, n + n3 - n6 / 2, (n2 + n4) / 2);
                }
                if (!bl) {
                    int n8;
                    int n9 = n + n3 - n6;
                    if (jProgressBar.isIndeterminate()) {
                        n8 = jProgressBar.getWidth() - n3;
                        int n10 = n6 / 2 + (jProgressBar.getWidth() - n6) * n / n8;
                        n9 = n10 - n6 / 2;
                    }
                    if (n9 >= 0) {
                        n8 = (n2 + n4 - n7) / 2;
                        graphics.drawImage(imageIcon.getImage(), n9, n8, n9 + n6, n8 + n7, 0, 0, n6, n7, null);
                    }
                }
            } else {
                if (!jProgressBar.isIndeterminate() && n4 >= n7) {
                    graphics2D.setPaint(color.brighter());
                    graphics2D.drawLine((n + n3) / 2 - 1, n2 + n7 / 2, (n + n3) / 2 - 1, n2 + n4 - n7 / 2);
                    graphics2D.setPaint(color.darker());
                    graphics2D.drawLine((n + n3) / 2 + 1, n2 + n7 / 2, (n + n3) / 2 + 1, n2 + n4 - n7 / 2);
                    graphics2D.setPaint(color);
                    graphics2D.drawLine((n + n3) / 2, n2 + n7 / 2, (n + n3) / 2, n2 + n4 - n7 / 2);
                }
                if (!bl) {
                    int n11 = (n + n3 - n6) / 2;
                    int n12 = n2;
                    if (jProgressBar.isIndeterminate()) {
                        int n13 = jProgressBar.getHeight() - n4;
                        int n14 = n7 / 2 + (jProgressBar.getHeight() - n7) * n2 / n13;
                        n12 = n14 - n7 / 2;
                    }
                    graphics.drawImage(imageIcon.getImage(), n11, n12, n11 + n6, n12 + n7, 0, 0, n6, n7, null);
                }
            }
        }
    }

    @Override
    public void paintRadioButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        ImageIcon imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, "RadioButton.icon");
        this.paintCheckRadioBackground(synthContext, graphics, imageIcon, n, n2, n3, n4);
    }

    @Override
    public void paintRadioButtonMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.doMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void paintPanelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JPanel jPanel = (JPanel)synthContext.getComponent();
        Color color = jPanel.getBackground();
        if (!color.equals(this.getDefaultBgColor())) {
            graphics.setColor(jPanel.getBackground());
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    @Override
    public void paintPasswordFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintTextFieldBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void paintPopupMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JPopupMenu jPopupMenu = (JPopupMenu)synthContext.getComponent();
        this.setSubmenuNames(jPopupMenu);
        this.drawRectBorder(synthContext, graphics, n, n2, n3, n4, false);
    }

    @Override
    public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.scrollbar.bg.color");
        if (color == null) {
            color = Color.WHITE;
        }
        graphics.setColor(color);
        graphics.fill3DRect(n, n2, n3, n4, true);
    }

    @Override
    public void paintScrollBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.common.border.color.enabled");
        if (color == null) {
            color = Color.DARK_GRAY;
        }
        graphics.setColor(color);
        graphics.draw3DRect(n, n2, n3 - 1, n4 - 1, true);
    }

    @Override
    public void paintScrollPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawRectBorder(synthContext, graphics, n, n2, n3, n4, false);
    }

    @Override
    public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if ((synthContext.getComponentState() & 0x100) != 0) {
            this.paintFocus(synthContext.getComponent(), graphics, n, n2, n3, n4, 0, 0, false);
        }
    }

    @Override
    public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        int n5 = uIDefaults.getInt("Cobalt.slider.track.arc.width");
        int n6 = uIDefaults.getInt("Cobalt.slider.track.arc.width");
        Color color = (synthContext.getComponentState() & 8) != 0 ? uIDefaults.getColor("Coable.slider.track.bg.color.disabled") : uIDefaults.getColor("Cobalt.slider.track.bg.color.normal");
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        graphics.setColor(color);
        graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        int n5 = uIDefaults.getInt("Cobalt.slider.track.arc.width");
        int n6 = uIDefaults.getInt("Cobalt.slider.track.arc.width");
        Color color = (synthContext.getComponentState() & 8) != 0 ? uIDefaults.getColor("Cobalt.common.border.color.disabled") : uIDefaults.getColor("Cobalt.common.border.color.enabled");
        if (color == null) {
            color = Color.GRAY;
        }
        graphics.setColor(color);
        graphics.drawRoundRect(n, n2, n3 - 1, n4 - 1, n5, n6);
    }

    @Override
    public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ImageIcon imageIcon = (synthContext.getComponentState() & 8) != 0 ? (n5 == 0 ? (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.slider.thumb.vertical.image.disabled") : (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.slider.thumb.horizontal.image.disabled")) : ((synthContext.getComponentState() & 2) != 0 ? (n5 == 0 ? (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.slider.thumb.vertical.image.mouseover") : (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.slider.thumb.horizontal.image.mouseover")) : (n5 == 0 ? (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.slider.thumb.vertical.image.normal") : (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.slider.thumb.horizontal.image.normal")));
        if (imageIcon != null) {
            int n6 = imageIcon.getIconWidth();
            int n7 = imageIcon.getIconHeight();
            int n8 = n + (n3 - n6) / 2;
            int n9 = n2 + (n4 - n7) / 2;
            graphics.drawImage(imageIcon.getImage(), n8, n9, n8 + n6, n9 + n7, 0, 0, n6, n7, null);
        }
    }

    @Override
    public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.splitpane.divider.maincolor");
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        graphics.setColor(color);
        graphics.fill3DRect(n, n2, n3, n4, true);
        ImageIcon imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.splitpane.divider.image");
        if (imageIcon != null) {
            int n5 = imageIcon.getIconWidth();
            int n6 = imageIcon.getIconHeight();
            JSplitPane jSplitPane = (JSplitPane)synthContext.getComponent();
            if (jSplitPane.getOrientation() == 1 && n4 >= n6 * 9) {
                int n7 = n + (n3 - n5) / 2;
                int n8 = n2 + (n4 - n6 * 3) / 2;
                graphics.drawImage(imageIcon.getImage(), n7, n8, n7 + n5, n8 + n6, 0, 0, n5, n6, null);
                graphics.drawImage(imageIcon.getImage(), n7, n8 + n6, n7 + n5, n8 + n6 * 2, 0, 0, n5, n6, null);
                graphics.drawImage(imageIcon.getImage(), n7, n8 + n6 * 2, n7 + n5, n8 + n6 * 3, 0, 0, n5, n6, null);
            } else if (n3 >= n5 * 9) {
                int n9 = n + (n3 - n5 * 3) / 2;
                int n10 = n2 + (n4 - n6) / 2;
                graphics.drawImage(imageIcon.getImage(), n9, n10, n9 + n5, n10 + n6, 0, 0, n5, n6, null);
                graphics.drawImage(imageIcon.getImage(), n9 + n5, n10, n9 + n5 * 2, n10 + n6, 0, 0, n5, n6, null);
                graphics.drawImage(imageIcon.getImage(), n9 + n5 * 2, n10, n9 + n5 * 3, n10 + n6, 0, 0, n5, n6, null);
            }
        }
    }

    @Override
    public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if ((synthContext.getComponentState() & 0x100) != 0) {
            JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
            ImageIcon imageIcon = null;
            if (jTabbedPane.getTabPlacement() == 1) {
                imageIcon = n5 == jTabbedPane.getSelectedIndex() ? (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.tabbedpane.bg.image.top.selected.focus") : (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.tabbedpane.bg.image.top.focus");
            } else if (jTabbedPane.getTabPlacement() == 3) {
                imageIcon = n5 == jTabbedPane.getSelectedIndex() ? (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.tabbedpane.bg.image.bottom.selected.focus") : (ImageIcon)synthContext.getStyle().getIcon(synthContext, "Cobalt.tabbedpane.bg.image.bottom.focus");
            }
            if (imageIcon != null) {
                CobaltGraphicsUtils.paintImage(imageIcon.getImage(), graphics, n, n2, n3, n4, new Insets(5, 4, 5, 4), new Insets(5, 4, 5, 4), true, true);
            }
            this.paintFocus(jTabbedPane.getSelectedComponent(), graphics, n, n2, n3, n4, 5, 5, true);
        }
    }

    @Override
    public void paintTabbedPaneTabAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        int n5 = jTabbedPane.getTabPlacement();
        UIDefaults uIDefaults = UIManager.getDefaults();
        int n6 = uIDefaults.getInt("Cobalt.tabbedArea.strip.thickness");
        Color color = uIDefaults.getColor("Cobalt.tabbedArea.bg.color.start");
        Color color2 = uIDefaults.getColor("Cobalt.tabbedArea.bg.color.end");
        Color color3 = uIDefaults.getColor("Cobalt.tabbedArea.bg.strip.color1");
        Color color4 = uIDefaults.getColor("Cobalt.tabbedArea.bg.strip.color2");
        if (n5 == 1) {
            CobaltPainter.gradientFillRect(graphics, n, n2, n3, n4 - n6, color, color2, true);
            graphics.setColor(color3);
            graphics.drawLine(n, n2 + n4 - n6, n + n3, n2 + n4 - n6);
            graphics.setColor(color4);
            graphics.fillRect(n, n2 + n4 - n6 + 1, n3, n6);
        } else if (n5 == 3) {
            graphics.setColor(color4);
            graphics.fillRect(n, n2, n3, n6 -= 3);
            graphics.setColor(color3);
            graphics.drawLine(n, n2 + n6, n + n3, n2 + n6);
            CobaltPainter.gradientFillRect(graphics, n, n2 + n6 + 1, n3, n4 - n6 - 1, color, color2, true);
        }
    }

    @Override
    public void paintTableHeaderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = (JTableHeader)synthContext.getComponent();
        Graphics2D graphics2D = (Graphics2D)graphics;
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.tableHeader.border.color");
        if (color == null) {
            color = defaultBdColorEnabled;
        }
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        int n5 = tableColumnModel.getColumnCount();
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            graphics2D.setPaint(color);
            if (n > 0) {
                graphics2D.drawLine(n + n6, n2, n + n6, n2 + n4 - 1);
            }
            int n7 = tableColumnModel.getColumn(i).getWidth();
            graphics2D.drawLine(n + n6, n2 + n4 - 1, n + n6 + n7, n2 + n4 - 1);
            graphics2D.drawLine(n + (n6 += n7 - 1), n2, n + n6, n2 + n4 - 1);
            n6 += tableColumnModel.getColumnMargin();
        }
    }

    @Override
    public void paintTextAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JTextArea jTextArea = (JTextArea)synthContext.getComponent();
        Color color = jTextArea.getBackground();
        if (!color.equals(this.getDefaultBgColor())) {
            return;
        }
        if (jTextArea.isFocusable() && jTextArea.isOpaque() && jTextArea.isEnabled() && jTextArea.isEditable()) {
            graphics.setColor(Color.white);
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    @Override
    public void paintTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JTextField jTextField = (JTextField)synthContext.getComponent();
        if (jTextField.getParent() instanceof JComboBox) {
            return;
        }
        this.drawRectBorder(synthContext, graphics, n, n2, n3, n4, false);
    }

    @Override
    public void paintToggleButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        JComponent jComponent = synthContext.getComponent();
        boolean bl = false;
        if ("true".equals(jComponent.getClientProperty("ToggleButton.skipBkgPaint"))) {
            bl = true;
        }
        boolean bl2 = false;
        if (jComponent.getParent() instanceof JToolBar && !(bl2 = jComponent.isFocusable())) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("Cobalt.togglebutton.bg.image.");
        boolean bl3 = false;
        if ((synthContext.getComponentState() & 0x100) != 0) {
            bl3 = true;
        }
        if ((synthContext.getComponentState() & 4) != 0 || (synthContext.getComponentState() & 0x200) != 0) {
            stringBuilder.append("pressed");
            if (bl) {
                stringBuilder.append(".lt");
            }
        } else if ((synthContext.getComponentState() & 2) != 0) {
            stringBuilder.append("mouseover");
            if (bl) {
                stringBuilder.append(".lt");
            }
        } else if ((synthContext.getComponentState() & 8) != 0) {
            stringBuilder.append("disabled");
        } else {
            stringBuilder.append("normal");
            if (bl) {
                stringBuilder.append(".lt");
            }
        }
        ImageIcon imageIcon = (ImageIcon)synthContext.getStyle().getIcon(synthContext, stringBuilder.toString());
        if (!bl2 && imageIcon != null) {
            n6 = imageIcon.getIconWidth();
            n5 = imageIcon.getIconHeight();
            graphics.drawImage(imageIcon.getImage(), n, n2, n3, n4, 0, 0, n6, n5, null);
        }
        if (bl3) {
            n6 = bl2 ? 1 : 3;
            n5 = bl2 ? 1 : 3;
            this.paintFocus(jComponent, graphics, n, n2, n3, n4, n6, n5, true);
        }
    }

    @Override
    public void paintToggleButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JToggleButton jToggleButton = (JToggleButton)synthContext.getComponent();
        boolean bl = false;
        if (jToggleButton.getIcon() == null) {
            jToggleButton.setName("ToggleButton.noIcon");
            bl = true;
        }
        this.paintButtonBorder(synthContext, graphics, n, n2, n3, n4, bl);
    }

    @Override
    public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JToolBar jToolBar;
        Color color;
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color2 = uIDefaults.getColor("Cobalt.toolbar.bg.color.start");
        if (color2 == null) {
            color2 = Color.LIGHT_GRAY;
        }
        if ((color = uIDefaults.getColor("Cobalt.toolbar.bg.color.end")) == null) {
            color = Color.WHITE;
        }
        CobaltPainter.gradientFillRect(graphics, n, n2, n3, n4, color2, color, (jToolBar = (JToolBar)synthContext.getComponent()).getOrientation() != 1);
    }

    @Override
    public void paintToolTipBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.toolTip.border.color");
        CobaltPainter.drawRectBorder(graphics, color, n, n2, n3, n4, false);
    }

    private void paintButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        JComponent jComponent = synthContext.getComponent();
        String string = "ToolBar.button";
        boolean bl2 = jComponent.getParent() instanceof JToolBar;
        if (bl2 && jComponent instanceof JButton && (jComponent.getName() == null || !jComponent.getName().equals(string))) {
            jComponent.setName(string);
        }
        if (jComponent instanceof JButton && !bl2) {
            return;
        }
        UIDefaults uIDefaults = UIManager.getDefaults();
        boolean bl3 = false;
        boolean bl4 = false;
        Color color = null;
        color = uIDefaults.getColor("Cobalt.button.border.color.normal");
        if ((synthContext.getComponentState() & 4) != 0 || (synthContext.getComponentState() & 0x200) != 0) {
            bl3 = true;
        } else if ((synthContext.getComponentState() & 2) != 0) {
            bl4 = true;
        } else if ((synthContext.getComponentState() & 8) != 0) {
            Color color2 = color = bl2 ? null : uIDefaults.getColor("Cobalt.button.border.color.disabled");
        }
        if (bl2) {
            color = null;
        } else if (bl) {
            color = jComponent.getBackground().darker();
        }
        if (bl3) {
            this.paintLoweredBevel(color, jComponent, graphics, n3, n4);
        } else if (bl4) {
            this.paintRaisedBevel(color, jComponent, graphics, n3, n4);
        } else if (color != null) {
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    private void doMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.menu.selected.bg.color.start");
        Color color2 = uIDefaults.getColor("Cobalt.menu.selected.bg.color.end");
        if ((synthContext.getComponentState() & 2) != 0 || (synthContext.getComponentState() & 2) != 0 && (synthContext.getComponentState() & 0x200) != 0) {
            CobaltPainter.gradientFillRect(graphics, n, n2, n3, n4, color, color2, true);
        }
    }

    private static void gradientFillRect(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, boolean bl) {
        if (color == null) {
            color = new Color(246, 250, 254);
        }
        if (color2 == null) {
            color2 = new Color(214, 226, 234);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = color2.getRed() - color.getRed();
        double d2 = color2.getGreen() - color.getGreen();
        double d3 = color2.getBlue() - color.getBlue();
        double d4 = color2.getAlpha() - color.getAlpha();
        if (bl) {
            for (int i = 1; i <= n4; ++i) {
                double d5 = (double)i / (double)n4;
                Color color3 = new Color(color.getRed() + (int)(d * d5), color.getGreen() + (int)(d2 * d5), color.getBlue() + (int)(d3 * d5), color.getAlpha() + (int)(d4 * d5));
                graphics2D.setPaint(color3);
                graphics2D.drawLine(n, n2 + i - 1, n + n3 - 1, n2 + i - 1);
            }
        } else {
            for (int i = 1; i <= n3; ++i) {
                double d6 = (double)i / (double)n3;
                Color color4 = new Color(color.getRed() + (int)(d * d6), color.getGreen() + (int)(d2 * d6), color.getBlue() + (int)(d3 * d6), color.getAlpha() + (int)(d4 * d6));
                graphics2D.setPaint(color4);
                graphics2D.drawLine(n + i - 1, n2, n + i - 1, n2 + n4 - 1);
            }
        }
        graphics2D.setPaint(null);
    }

    private static void drawRectBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        if (bl) {
            graphics2D.draw3DRect(n, n2, n3 - 1, n4 - 1, false);
        } else {
            graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    private static void drawRoundRectBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color2 = graphics2D.getColor();
        graphics2D.setColor(color != null ? color : defaultBdColorEnabled);
        graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 1, n5, n6);
        graphics2D.setColor(color2);
    }

    private void drawRectBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("Cobalt.common.border.color.disabled");
        Color color2 = uIDefaults.getColor("Cobalt.common.border.color.enabled");
        if ((synthContext.getComponentState() & 8) != 0) {
            color2 = color != null ? color : defaultBdColorDisabled;
        }
        CobaltPainter.drawRectBorder(graphics, color2, n, n2, n3, n4, bl);
    }

    private void drawRoundRectBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        int n5 = uIDefaults.getInt("Cobalt.common.border.arc.width");
        int n6 = uIDefaults.getInt("Cobalt.common.border.arc.height");
        Color color = uIDefaults.getColor("Cobalt.common.border.color.disabled");
        Color color2 = uIDefaults.getColor("Cobalt.common.border.color.enabled");
        if ((synthContext.getComponentState() & 8) != 0) {
            color2 = color != null ? color : defaultBdColorDisabled;
        }
        CobaltPainter.drawRoundRectBorder(graphics, color2, n, n2, n3, n4, n5, n6);
    }

    private void paintEtchedBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, boolean bl) {
        graphics.setColor(bl ? color : color2);
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.setColor(bl ? color2 : color);
        graphics.drawLine(1, n4 - 3, 1, 1);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
    }

    private void paintLoweredBevel(Color color, Component component, Graphics graphics, int n, int n2) {
        graphics.setColor(color != null ? color.darker() : component.getBackground().darker());
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.drawLine(1, 0, n - 1, 0);
        graphics.setColor(color != null ? color.brighter() : component.getBackground().brighter());
        graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
    }

    private void paintRaisedBevel(Color color, Component component, Graphics graphics, int n, int n2) {
        graphics.setColor(color != null ? color.brighter().brighter() : component.getBackground().brighter().brighter());
        graphics.drawLine(0, 0, 0, n2 - 2);
        graphics.drawLine(1, 0, n - 2, 0);
        graphics.setColor(color != null ? color.darker().darker() : component.getBackground().darker().darker());
        graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, 0, n - 1, n2 - 2);
    }

    private void paintFocus(Component component, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (component.getName() != null && component.getName().equals(CompNameToSkipFocusPaint)) {
            return;
        }
        Color color = CobaltGraphicsUtils.convertIfColorEqualsBackground(component.getBackground(), UIManager.getColor("ToggleButton.focus"));
        graphics.setColor(color);
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (bl) {
            rectangle.grow(-n5, -n6);
            CobaltGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            CobaltGraphicsUtils.drawDashedRect(graphics, n + 2, n2, n3 - 2, n4);
        }
    }

    private void paintCheckRadioBackground(SynthContext synthContext, Graphics graphics, Icon icon, int n, int n2, int n3, int n4) {
        int n5;
        String string = null;
        JComponent jComponent = synthContext.getComponent();
        if (jComponent instanceof JRadioButton) {
            string = ((JRadioButton)jComponent).getText();
        } else if (jComponent instanceof JCheckBox) {
            string = ((JCheckBox)jComponent).getText();
        }
        if ((synthContext.getComponentState() & 0x200) != 0) {
            int n6 = n5 = jComponent.getName() != null && jComponent.getName().equals(CompNameToSkipFocusPaint) ? 1 : 0;
            if ((string == null || string.length() == 0) && synthContext.getComponent() instanceof JRadioButton && n5 == 0) {
                this.paintButtonBorder(synthContext, graphics, n, n2, n3, n4, false);
            }
        }
        if ((synthContext.getComponentState() & 0x100) != 0) {
            n5 = 15;
            if (icon != null) {
                n5 = icon.getIconWidth();
            }
            if (string != null && string.length() > 0) {
                this.paintFocus(synthContext.getComponent(), graphics, n + n5, n2, n3 - n5, n4, 0, 0, false);
            } else {
                this.paintFocus(synthContext.getComponent(), graphics, n - 1, n2, n3, n4, 0, 0, false);
            }
        }
    }

    private void setSubmenuNames(MenuElement menuElement) {
        block3: {
            Component[] componentArray;
            block2: {
                Component[] componentArray2;
                if (!(menuElement instanceof JMenu)) break block2;
                this.setName((JMenu)menuElement);
                for (Component component : componentArray2 = ((JMenu)menuElement).getMenuComponents()) {
                    this.setName(component);
                }
                break block3;
            }
            if (!(menuElement instanceof JPopupMenu)) break block3;
            for (Component component : componentArray = ((JPopupMenu)menuElement).getComponents()) {
                this.setName(component);
            }
        }
    }

    private void setName(Component component) {
        if (component instanceof JMenu && component.getParent() instanceof JPopupMenu && (component.getName() == null || !component.getName().equals(submenuName))) {
            component.setName(submenuName);
        }
    }

    public static class CBLineBorder
    extends LineBorder {
        static String copyright() {
            return "\n\nLicensed Materials - Property of IBM\nIBM SPSS Products: SPSS Common\n(C) Copyright IBM Corp. 1989, 2011.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        }

        public CBLineBorder(int n, int n2, int n3) {
            super(new Color(n, n2, n3));
        }
    }

    public static class CBEtchedBorder
    extends EtchedBorder {
        static String copyright() {
            return "\n\nLicensed Materials - Property of IBM\nIBM SPSS Products: SPSS Common\n(C) Copyright IBM Corp. 1989, 2011.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        }

        public CBEtchedBorder(int n, int n2, int n3, int n4, int n5, int n6) {
            super(0, new Color(n, n2, n3), new Color(n4, n5, n6));
        }
    }
}

