/*
 * Decompiled with CFR 0.152.
 */
package com.spss.cobalt_laf;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.SynthLookAndFeel;

public class CobaltLookAndFeel
extends SynthLookAndFeel {
    public static final String CobaltDefaultFontKey = "Cobalt.default.font";
    private String internalSynthXml = "cobalt.xml";
    private String synthXml;
    private Font defaultFont;
    private UIDefaults storedUIDefaults;

    static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nIBM SPSS Products: SPSS Common\n(C) Copyright IBM Corp. 1989, 2011.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public CobaltLookAndFeel() {
        this(null, null);
    }

    public CobaltLookAndFeel(Font font) {
        this(null, font);
    }

    public CobaltLookAndFeel(float f) {
        this(null, f);
    }

    public CobaltLookAndFeel(File file, Font font) {
        try {
            if (file == null) {
                this.load(this.getClass().getResourceAsStream(this.internalSynthXml), this.getClass());
            } else {
                URL uRL = new URL("file:" + file.getAbsolutePath());
            }
            this.defaultFont = font == null ? this.getDefaultFontInXml() : font;
            this.setDefaultFont(this.defaultFont);
        }
        catch (Exception exception) {
            System.err.println("Couldn't get Synth look and feel for some reason.\nUsing the default look and feel");
            exception.printStackTrace();
        }
    }

    public CobaltLookAndFeel(File file, float f) {
        try {
            if (file == null) {
                this.load(this.getClass().getResourceAsStream(this.internalSynthXml), this.getClass());
            } else {
                URL uRL = new URL("file:" + file.getAbsolutePath());
            }
            this.defaultFont = this.getDefaultFontInXml().deriveFont(f);
            this.setDefaultFont(this.defaultFont);
        }
        catch (Exception exception) {
            System.err.println("Couldn't get Synth look and feel for some reason.\nUsing the default look and feel");
            exception.printStackTrace();
        }
    }

    public void installMissingUIDefaults() {
        Enumeration enumeration = this.storedUIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = this.storedUIDefaults.get(k);
            UIManager.getDefaults().put(k, object);
        }
    }

    @Override
    public String getDescription() {
        return "Extended Synth Look and Feel, generated by SPSS Cobalt Look and Feel Designer.";
    }

    @Override
    public String getID() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    private void setDefaultFont(Font font) {
        if (font != null) {
            int n = font.getSize();
            this.realizeFont(font.getName(), n, font.isBold(), font.isItalic());
            this.defaultFont = font;
        }
    }

    private void realizeFont(String string, int n, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("$1");
        stringBuilder.append(string);
        stringBuilder.append("$3");
        stringBuilder.append(n);
        stringBuilder.append("$5");
        if (bl || bl2) {
            stringBuilder.append(" style=\"");
            if (bl) {
                stringBuilder.append("BOLD");
                if (bl2) {
                    stringBuilder.append(' ');
                }
            }
            if (bl2) {
                stringBuilder.append("ITALIC");
            }
            stringBuilder.append("\"");
        }
        stringBuilder.append("$7");
        this.replaceXmlSegment("(<style id=\"default\">\\s*<font id=\"defaultFont\" name=\")([^\"]*)(\" size=\")([^\"]*)(\")([^/]*)(/>)", stringBuilder.toString());
        this.provideUIFont(string, n, bl, bl2);
    }

    private void replaceXmlSegment(String string, String string2) {
        this.replaceXmlSegmentInCache(string, string2);
        this.applyCachedSynthXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceXmlSegmentInCache(String string, String string2) {
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.synthXml == null) {
                this.synthXml = this.getSynthXmlAsString();
            }
        }
        serializable = Pattern.compile(string);
        Matcher matcher = ((Pattern)serializable).matcher(this.synthXml);
        this.synthXml = matcher.replaceFirst(string2);
    }

    private void applyCachedSynthXml() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.synthXml.getBytes("UTF-8"));
            this.load(byteArrayInputStream, this.getClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getSynthXmlAsString() {
        InputStream inputStream = this.getClass().getResourceAsStream("cobalt.xml");
        if (inputStream != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String string = null;
                StringBuilder stringBuilder = new StringBuilder();
                do {
                    if ((string = bufferedReader.readLine()) == null) continue;
                    stringBuilder.append(string.trim());
                    stringBuilder.append(System.getProperty("line.separator"));
                } while (string != null);
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private void provideUIFont(String string, int n, boolean bl, boolean bl2) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        if (bl2) {
            n2 = 2;
        }
        if (bl && bl2) {
            n2 = 3;
        }
        FontUIResource fontUIResource = new FontUIResource(string, n2, n);
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof FontUIResource)) continue;
            UIManager.put(k, fontUIResource);
        }
    }

    private Font getDefaultFontInXml() {
        UIDefaults uIDefaults = this.getDefaults();
        return uIDefaults.getFont(CobaltDefaultFontKey);
    }

    private void storeUIDefaults() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Object[] objectArray = new Object[]{"FileChooser.lookInLabelMnemonic", uIDefaults.getInt("FileChooser.lookInLabelMnemonic"), "FileChooser.fileNameLabelMnemonic", uIDefaults.getInt("FileChooser.fileNameLabelMnemonic"), "FileChooser.filesOfTypeLabelMnemonic", uIDefaults.getInt("FileChooser.filesOfTypeLabelMnemonic"), "FileChooser.folderNameLabelMnemonic", uIDefaults.getInt("FileChooser.folderNameLabelMnemonic"), "FileChooser.folderNameLabelText", uIDefaults.getInt("FileChooser.folderNameLabelText")};
        this.storedUIDefaults = new UIDefaults(objectArray);
    }
}

